// 8x8 size

#pragma once
#ifndef life_h
#define life_h

#include "Arduino.h"

// conway's game of life
class CONWAYS_LIFE
{
  public:
    void start( boolean wrap );
    void run();
    
    boolean  wrap;      // edge wrap enable

    uint     initial;   // initial live cells
    uint8_t  board[8];  // current state
    uint     alive;     // number of alive cells
};

//- - - - - - - - - - - - - - -

void CONWAYS_LIFE::start(boolean wrap)
{
  this->wrap = wrap;
  for (uint i=0; i < 8; i++) board[i] = 0;
  for (uint i=0; i < initial; i++)
  { uint r = random(0,8);
    uint b = random(0,8);
    if (board[r] & (1 << b)) { i--; continue; }
    board[r] |= 1 << b;
  }
  alive = initial;
}

//- - - - - - - - - - - - - - -

void CONWAYS_LIFE::run()
{
  uint16_t firstRow; // for wrap
  firstRow = board[0];
 
  uint16_t prevRow; // the row above thisRow
  prevRow = wrap ? board[7] : 0;

  uint16_t nextRow;
  uint16_t thisRow; // the row that's being calculated now

  alive = 0;        // count live cells
  for (int r=0; r < 8; r++)
  {
      // get this row and next row
      thisRow = board[r];
      if (r == 7) nextRow = wrap ? firstRow : 0; else nextRow = board[r+1];
      
      // calculate lifeBoard[r].row
      board[r] = 0;
      for (int c=0; c < 8; c++)
      { /*
            Any live cell with fewer than two live neighbours dies, as if caused by under-population.
            Any live cell with two or three live neighbours lives on to the next generation.
            Any live cell with more than three live neighbours dies, as if by overcrowding.
            Any dead cell with exactly three live neighbours becomes a live cell, as if by reproduction.
        */
        int n; // number of alive neighbors
        if (wrap)
        { // wrap at boundaries
          int cm1 = (c-1+8) & 7;
          int cp1 = (c+1)    & 7;
          n = ((thisRow & (1 << cm1)) ? 1:0) + ((thisRow & (1 << cp1)) ? 1:0)
            + ((prevRow & (1 << c)) ? 1:0) + ((prevRow & (1 << cm1)) ? 1:0) + ((prevRow & (1 << cp1)) ? 1:0)
            + ((nextRow & (1 << c)) ? 1:0) + ((nextRow & (1 << cm1)) ? 1:0) + ((nextRow & (1 << cp1)) ? 1:0);
        } else
        { // nothing beyond boundaries
          unsigned int cm1 = (c >  0) ? 1 << (c-1) : 0;
          unsigned int cp1 = (c < 7) ? 1 << (c+1) : 0;
          n = ((thisRow & cm1) ? 1:0) + ((thisRow & cp1) ? 1:0)
            + ((prevRow & (1 << c)) ? 1:0) + ((prevRow & cm1) ? 1:0) + ((prevRow & cp1) ? 1:0)
            + ((nextRow & (1 << c)) ? 1:0) + ((nextRow & cm1) ? 1:0) + ((nextRow & cp1) ? 1:0);
        }
        if (thisRow & (1 << c))
           { if (n == 2 || n == 3) board[r] |= (1 << c); }
        else
           { if (n == 3) board[r] |= (1 << c); }

        if (board[r] & (1 << c)) alive++;
      }
      prevRow = thisRow;
  }
}

#endif
