#pragma once
#ifndef player_lib
#define player_lib

#include <vector>        // dynamic array

#include <MIDI.h>
//extern MIDI_NAMESPACE::MidiInterface<MIDI_NAMESPACE::SerialMIDI<HardwareSerial>> MIDI;
//SerialPIO SerialTx( 3, SerialPIO::NOPIN, FIFOSIZE );
//MIDI_CREATE_INSTANCE(SerialPIO, SerialTx,  MIDI);
extern MIDI_NAMESPACE::MidiInterface<MIDI_NAMESPACE::SerialMIDI<SerialPIO>> MIDI;

class autoPlayer
{
  private:
    struct playing_note 
    {
      byte  channel;
      byte  pitch;
      ulong msecs;
      ulong tm;
    };
    std::vector<playing_note> playing_notes;

  public:
    void init()
    {
      playing_notes.clear();
    }
    
#define MAX_SIMULTANEOUS_NOTES 3
    void play( byte channel, byte pitch, byte velocity, ulong msecs )
    {
      // ignore note if already playing
      for (auto pn_it = playing_notes.begin(); pn_it != playing_notes.end(); ++pn_it) 
        if (pn_it->channel == channel && pn_it->pitch == pitch)
          return;
      // don't play too many notes at once
      if (playing_notes.size() >= MAX_SIMULTANEOUS_NOTES) return;
      // start new note      
      playing_note n = {channel,pitch,msecs,millis()};
      playing_notes.push_back(n);
      MIDI.sendNoteOn( pitch, velocity, channel );
    }

    void run()
    {
      for (auto pn_it = playing_notes.begin(); pn_it != playing_notes.end(); ++pn_it) 
        if (millis() - pn_it->tm >= pn_it->msecs)
        { MIDI.sendNoteOff( pn_it->pitch, 0, pn_it->channel );
          playing_notes.erase(pn_it--);
        }
    }
};

#endif
