// VelociBus superclass to handle 2x2 board arrangement
class VelociBus_2x2_boards : public VelociBus_4X4BP
{
  // The "Initialization & Diagnostic" example can be used to identify the board arrangement.

  // Board arrangement:
  //   01234567
  //   +---+---+ 0
  //   | 3 | 2 | 1 
  //   +---+---+ 2
  //   | 1 | 0 |...
  //   +---+---+ 7
  #define BOARD_ROWS 2
  #define BOARD_COLS 2
  
  private:
    const byte board_map[BOARD_ROWS][BOARD_COLS] = { {3,2}, {1,0} };

  public:
    void setRow( byte row_index, 
                 lamp_fcn fcn, color_code color )
    {
      for (uint brd=0; brd < BOARD_ROWS; brd++) setLEDrow( board_map[row_index/4][brd], row_index % 4, fcn, color );
    }
    
    void setCol( byte col_index, 
                 lamp_fcn fcn, color_code color )
    {
      for (uint brd=0; brd < BOARD_COLS; brd++) setLEDcol( board_map[brd][col_index/4], col_index % 4, fcn, color );
    }

    void setXY( byte col_index,
                byte row_index,  
                lamp_fcn fcn, color_code color )
    {
      setLED( board_map[row_index/4][col_index/4], 4*(row_index % 4) + col_index % 4, fcn, color );
    }

    struct point { byte x; byte y; };
    point getXY( uint8_t board_address, uint8_t button_index )
    {
      // locate board
      for (byte r=0; r < BOARD_ROWS; r++)
        for (byte c=0; c < BOARD_COLS; c++)
          if (board_map[r][c] == board_address)
          { point p;
            p.x = c*4 + (button_index % 4);
            p.y = r*4 +  button_index / 4;
            return p;
          }
       // hmmm, throw an error?
       return {0,0};
    }
};
