#pragma once
#ifndef Lib_app
#define Lib_app

#include <Arduino.h>

// program name
#define APP_NAME "Touch Clock 2024"

// landscape mode display
#define DISP_H 240
#define DISP_W 320
#define BL_PIN 2              // display backlight PWM
#define MIN_BRIGHTNESS  64
#define MAX_BRIGHTNESS 255

#define SNOOZE_MINUTES 10UL

#define MP3_BEEP     1
#define MP3_REDALERT 2

#define POWER_PIN  6
#define LIGHT_PIN 13
#define BUSY_PIN  10
#define SQW_PIN   11  // 1Hz interrupt

#define VOLUME_PIN     A0 // not implemented
#define BRIGHTNESS_PIN A1 // LDR voltage divider

struct ClockTime
{ byte seconds; // BCD seconds
  byte minutes; // BCD minutes
  byte hours;   // BCD hours
  boolean pm;
};

//-------------------------------------------------------------------
// touch screen calibration stored in emulated EEPROM

#include <EEPROM.h>

struct touch_cal_struct
{ // touch coordinates for screen dimensions
  int16_t min_x; 
  int16_t max_x;
  int16_t min_y;
  int16_t max_y;   
};

//-------------------------------------------------------------------
// coroutine macros

#define coBegin { switch(_state_) { case 0:;
#define coEnd        _state_ = 0; }}
#define coDebounce(msec,expr) { _state_ = __LINE__; _tm_=millis(); return; case __LINE__: if (!(expr)) _tm_=millis(); if (millis()-_tm_ < msec) return; }
#define coDelay(msec) { _state_ = __LINE__; _tm_=millis(); return; case __LINE__: if (millis()-_tm_ < msec) return; }
#define coDelayWhile(msec,expr) { _state_ = __LINE__; _tm_=millis(); return; case __LINE__: if ((millis()-_tm_ < msec) && (expr)) return; }
#define coWaitWhile(expr) { _state_ = __LINE__; return;  case __LINE__: if (expr) return; }

#endif
